from ._base_dag import BaseDAG, Level1DAG, Level2DAG
from ._dispatcher import Dispatcher
from .._csst import csst
from ..dag_utils import generate_permutations

CSST_DAGS = {
    # MSC
    "csst-msc-l1-qc0": Level1DAG(
        dag="csst-msc-l1-qc0",
        pattern=generate_permutations(
            instrument=["MSC"],
            obs_type=["BIAS", "DARK", "FLAT"],
        ),
        dispatcher=Dispatcher.dispatch_file,
    ),
    "csst-msc-l1-mbi": Level1DAG(
        dag="csst-msc-l1-mbi",
        pattern=generate_permutations(
            instrument=["MSC"],
            obs_type=["WIDE", "DEEP"],
            detector=csst["MSC"]["MBI"].effective_detector_names,
        ),
        dispatcher=Dispatcher.dispatch_file,
    ),
    "csst-msc-l1-ast": Level1DAG(
        dag="csst-msc-l1-ast",
        pattern=generate_permutations(
            instrument=["MSC"],
            obs_type=["WIDE", "DEEP"],
            detector=csst["MSC"]["MBI"].effective_detector_names,
        ),
        dispatcher=Dispatcher.dispatch_file,
    ),
    "csst-msc-l1-sls": Level1DAG(
        dag="csst-msc-l1-sls",
        pattern=generate_permutations(
            instrument=["MSC"],
            obs_type=["WIDE", "DEEP"],
            detector=csst["MSC"]["SLS"].effective_detector_names,
        ),
        dispatcher=Dispatcher.dispatch_file,
    ),
    "csst-msc-l1-ooc": Level1DAG(
        dag="csst-msc-l1-ooc",
        pattern=generate_permutations(
            instrument=["MSC"],
            obs_type=["BIAS", "DARK", "FLAT"],
            detector=csst["MSC"].effective_detector_names,
        ),
        dispatcher=Dispatcher.dispatch_obsgroup_detector,
    ),
    # MCI
    "csst-mci-l1": Level1DAG(
        dag="csst-mci-l1",
        pattern=generate_permutations(
            instrument=["MCI"],
            obs_type=["EXDF", "COMB", "TRNS", "PI", "CALS", "CALF"],
            detector=csst["MCI"].effective_detector_names,
        ),
        dispatcher=Dispatcher.dispatch_file,
    ),
    "csst-mci-l1-qc0": Level1DAG(
        dag="csst-mci-l1",
        pattern=generate_permutations(
            instrument=["MCI"],
            obs_type=["BIAS", "DARK", "FLAT"],
            detector=csst["MCI"].effective_detector_names,
        ),
        dispatcher=Dispatcher.dispatch_file,
    ),
    # IFS
    "csst-ifs-l1": Level1DAG(
        dag="csst-ifs-l1",
        pattern=generate_permutations(
            instrument=["IFS"],
            obs_type=["SCI", "COMB"],
            detector=csst["IFS"].effective_detector_names,
        ),
        dispatcher=Dispatcher.dispatch_obsid,
    ),
    # CPIC
    "csst-cpic-l1": Level1DAG(
        dag="csst-cpic-l1",
        pattern=generate_permutations(
            instrument=["CPIC"],
            obs_type=["SCI", "DSF", "CALS"],
            detector=csst["CPIC"].effective_detector_names,
        ),
        dispatcher=Dispatcher.dispatch_file,
    ),
    "csst-cpic-l1-qc0": Level1DAG(
        dag="csst-cpic-l1-qc0",
        pattern=generate_permutations(
            instrument=["CPIC"],
            obs_type=["BIAS", "DARK", "FLAT", "BKG", "LASER"],
            detector=csst["CPIC"].effective_detector_names,
        ),
        dispatcher=Dispatcher.dispatch_file,
    ),
    # HSTDM
    "csst-hstdm-l1": Level1DAG(
        dag="csst-hstdm-l1",
        pattern=generate_permutations(
            instrument=["HSTDM"],
            obs_type=["STARE", "OTF"],
            detector=csst["HSTDM"].effective_detector_names,
        ),
        dispatcher=Dispatcher.dispatch_obsgroup,
    ),
}
