import os
import sys

from csst_common.cicd import Pipeline

# configure pipeline
p = Pipeline(
    dir_input="/pipeline/input",
    dir_output="/pipeline/output",
    dir_aux="/pipeline/aux",
    dfs_root="/dfs_root",
    ccds_root="/ccds_root",
    ccds_cache="/pipeline/ccds_cache",
    pipeline_log="pipeline.log",
    clean_output_before_run=True,
    filter_warnings=False,
    dfs=True,
    ccds=True,
)
p.info()


# parse JSON message
if len(sys.argv) == 2:
    msg = sys.argv[1]
else:
    raise ValueError("sys.argv[1] is required")
d = p.message.msg2dict(msg)

print(f"Input message: {d}")
p.pipeline_logger.info(f"sys.argv = {sys.argv}")
exit(0)