# CSST DFS数据服务客户端

[![pipeline status](https://csst-tb.bao.ac.cn/code/csst-dfs/csst-dfs-client/badges/main/pipeline.svg)](https://csst-tb.bao.ac.cn/code/csst-dfs/csst-dfs-client/commits/main)
[![coverage](https://csst-tb.bao.ac.cn/code/csst-dfs/csst-dfs-client/badges/main/coverage.svg?job=test-job)](https://csst-tb.bao.ac.cn/code/csst-dfs/csst-dfs-client/-/jobs)
[![Static Badge](https://img.shields.io/badge/Python-3.11-green)](https://www.python.org/)
[![License](https://img.shields.io/badge/license-MIT-blue)](LICENSE)
[![Latest Release](https://csst-tb.bao.ac.cn/code/csst-dfs/csst-dfs-client/-/badges/release.svg)](https://csst-tb.bao.ac.cn/code/csst-dfs/csst-dfs-client/-/releases)

## 依赖

- requests==2.31.0
- boto3==1.35.24 # only required for S3 storage
- pandas==2.2.1 # only required for catalog query

## 安装

`csst-dfs-client` 可用如下方式安装

```shell
git clone https://csst-tb.bao.ac.cn/code/csst-dfs/csst-dfs-client.git
cd csst-dfs-client
pip install .
```

或者单行命令：

```shell
pip install --force-reinstall git+https://csst-tb.bao.ac.cn/code/csst-dfs/csst-dfs-client.git
```

## 配置环境变量

```shell
export CSST_DFS_GATEWAY=10.80.1.22:28000
export CSST_DFS_TOKEN=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJleHAiOjQ4ODU0NTA2NjQsInN1YiI6InN5c3RlbSJ9.POsuUABytu8-WMtZiYehiYEa5BnlgqNTXT6X3OTyix0
```

> 10.80.1.22:28000为国台环境

## 数据模型说明

[查看文档](https://csst-tb.bao.ac.cn/pipeline/devops/dfs/database/index.html)

## 接口使用说明

[查看文档](https://csst-tb.bao.ac.cn/pipeline/devops/dfs/api/index.html)
