import unittest
import os
from csst_dfs_client import download_file, read_file, get_free_header

class CommonTestCase(unittest.TestCase):
    def setUp(self):
        pass

    def test_download_level0_file(self):
        bytes_data = download_file(file_path= "L2/MSC/094/auto/CSST-MSC-L2-MBI-CAT/254/CSST_MSC_MS_SCI_20310423084104_20310423084334_10109400638867_12_L2_V01_CATMIX.fits")
        # save the downloaded file to a local directory
        tmp_file_dir = os.environ.get("UNIT_TEST_DATA_ROOT", "/tmp")
        tmp_file_path = os.path.join(tmp_file_dir, "test_downloaded_file.fits")
        if os.path.exists(tmp_file_path):
            os.remove(tmp_file_path)

        with open(tmp_file_path, "wb") as f:
            f.write(bytes_data)
        
        assert os.path.exists(tmp_file_path)
        os.remove(tmp_file_path)

    def test_read_file(self):
        bytes_io = read_file(file_path= "L2/MSC/094/auto/CSST-MSC-L2-MBI-CAT/254/CSST_MSC_MS_SCI_20310423084104_20310423084334_10109400638867_12_L2_V01_CATMIX.fits")
        # save the downloaded file to a local directory
        tmp_file_dir = os.environ.get("UNIT_TEST_DATA_ROOT", "/tmp")
        tmp_file_path = os.path.join(tmp_file_dir, "test_downloaded_file.fits")
        if os.path.exists(tmp_file_path):
            os.remove(tmp_file_path)

        with open(tmp_file_path, "wb") as f:
            f.write(bytes_io.getvalue())
        
        assert os.path.exists(tmp_file_path)
        os.remove(tmp_file_path)

    def test_get_free_header(self):
        header_items = get_free_header(file_path= "L2/MSC/094/auto/CSST-MSC-L2-MBI-CAT/254/CSST_MSC_MS_SCI_20310423084104_20310423084334_10109400638867_12_L2_V01_CATMIX.fits")
        print(header_items)     
        