import unittest
from csst_dfs_client import other

class OtherTestCase(unittest.TestCase):

    def setUp(self):
        pass

    def test_find(self):
        try:
            result = other.find(
                instrument='MSC',
                dag_run="test_dag_run",
                create_time=("2024-01-01 00:00:00", "2024-12-31 23:59:59"),
                page=1,
                limit=10
            )
            print(f"find result: {result}")
            self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)
            if result.success:
                self.assertIsNotNone(result.data, "data is None")
        except Exception as e:
            print(f"find skip, reason: {e}")

    def test_get_by_id(self):
        try:
            test_id = "1212"
            result = other.get_by_id(test_id)
            print(f"get_by_id result: {result}")
            self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)
            if result.success:
                self.assertIsNotNone(result.data, "data is None")
        except Exception as e:
            print(f"get_by_id skip, reason: {e}")

    def test_write(self):
        try:
            test_file_path = "/path/to/test/file.txt"
            result = other.write(
                local_file=test_file_path,
                test_param="test_value"
            )
            print(f"write result: {result}")
        except FileNotFoundError:
            print("write skip, reason: file not found")
        except Exception as e:
            print(f"write skip, reason: {e}")

    def test_delete(self):
        try:
            result = other.delete(
                instrument='MSC',
                dag_run="test_dag_run_for_deletion"
            )
            print(f"delete result: {result}")
            self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)
        except Exception as e:
            print(f"delete skip, reason: {e}")

if __name__ == '__main__':
    unittest.main()