import setuptools
import os

with open("README.md", "r", encoding="utf-8") as f:
    long_description = f.read()

with open("requirements.txt", "r") as f:
    requirements = [
        req.strip()
        for req in f.readlines()
        if not req.startswith("#") and req.__contains__("==")
    ]

def version():
    __version = {}
    version_path = os.path.join(os.path.dirname(__file__), "csst_dfs_client", "version.py")
    with open(version_path, "r") as file:
        exec(file.read(), __version)
    return __version["__version__"]

setuptools.setup(
    name="csst-dfs-client",
    version=version(),
    author="Shoulin Wei",
    author_email="weishoulin@kust.edu.cn",
    description="CSST DFS Project",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://csst-tb.bao.ac.cn/code/csst-dfs/csst-dfs-client",
    packages=setuptools.find_packages(where="." , exclude=['tests']), 
    license="MIT",
    classifiers=[
        # How mature is this project?
        #   3 - Alpha
        #   4 - Beta
        #   5 - Production/Stable
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Science/Research",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Topic :: Scientific/Engineering :: Physics",
        "Topic :: Scientific/Engineering :: Astronomy",
    ],
    include_package_data=False,
    python_requires=">=3.9",
    install_requires=requirements
)
