import unittest
from csst_dfs_client import other

class OtherTestCase(unittest.TestCase):

    def setUp(self):
        pass

    def test_find(self):
        try:
            result = other.find(
                instrument='MSC',
                dag_run="test_dag_run",
                create_time=("2024-01-01 00:00:00", "2025-12-31 23:59:59"),
                page=1,
                limit=10
            )
            print(f"find result: {result}")
            self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)
            if result.success:
                self.assertIsNotNone(result.data, "data is None")
        except Exception as e:
            print(f"find skip, reason: {e}")

    def test_get_by_id(self):
        try:
            test_id = "6914879b56e864f1f2abce7b"
            result = other.get_by_id(test_id)
            print(f"get_by_id result: {result}")
            self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)
            if result.success:
                self.assertIsNotNone(result.data, "data is None")
        except Exception as e:
            print(f"get_by_id skip, reason: {e}")

    def test_write(self):
        try:
            test_file_path = "/Users/wsl/temp/csst/CSST_MSC_MS_SCI_20240617065639_20240617065909_100000020_07_cat.fits"
            result = other.write(
                local_file=test_file_path,
                instrument='MSC',
                dag_run="test_dag_run",
                test_param="test_value"
            )
            print(f"write result: {result}")
        except FileNotFoundError:
            print("write skip, reason: file not found")
        except Exception as e:
            print(f"write skip, reason: {e}")

    def test_delete(self):
        try:
            result = other.delete(
                instrument='MSC',
                dag_run="test_dag_run"
            )
            print(f"delete result: {result}")
            self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)
        except Exception as e:
            print(f"delete skip, reason: {e}")

if __name__ == '__main__':
    unittest.main()