import unittest
from csst_dfs_client import dag

class DAGTestCase(unittest.TestCase):

    def setUp(self):
        pass


    def test_new_group_run(self):
        dag_group_run = {"dag_group": "csst_dag.cli.msc_l1",
            "dag_group_run": "195244ff176f923aec9a9328c75ecaeb4a8c4345",
            "batch_id": "inttest",
            "priority": 1
        }
        dag_run_list = [{
            "dag_group": "csst_dag.cli.msc_l1",
            "dag_group_run": "195244ff176f923aec9a9328c75ecaeb4a8c4345",
            "batch_id": "inttest",
            "priority": 1,
            "dag": "csst-msc-l1-mbi",
            "dag_run": "61b622a5d256806082c668b2d1273668a1eee3ec",
            "dataset": "csst-msc-c9-25sqdeg-v3",
            "obs_type": "WIDE",
            "filter": "r",
            "obs_group": "none",
            "obs_id": "10100232366",
            "detector": "09",
            "object": "J0842+0000",
            "proposal_id": "P0002"
        }]
        result = dag.new_dag_group_run(dag_group_run = dag_group_run, dag_run_list = dag_run_list)
        print("new_dag_group_run:", result)
        self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message) 

    def test_find_dag_group_run(self):
        result = dag.find_group_run(dag_group = "csst_dag.cli.msc_l1", batch_id = "inttest")
        print("find_dag_group_run:", result)
        self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)

    def test_find_dag_run(self):
        result = dag.find_dag_run(dag_group = "csst_dag.cli.msc_l1", batch_id = "inttest", object= "J0842+0000")
        print("find_dag_run:", result)
        self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)
        
    def test_update_dag_run(self):
        result = dag.update_dag_run(dag_run = "195244ff176f923aec9a9328c75ecaeb4a8c4345", status_code = 1)
        print("update_dag_run:", result)
        self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)
