import unittest
import time
from csst_dfs_client import plan

class PlanTestCase(unittest.TestCase):

    def setUp(self):
        pass

    def test_find(self):
        start_time = time.time()
        result = plan.find(obs_id = "101000100412",
                        obstime = ("2021-08-30 00:00:00", "2024-12-30 23:59:59"))
        if result.success:
            print(f"time used: {time.time() - start_time} 's, count: {result['total_count']}")
        else:
            print(f"time used: {time.time() - start_time} 's, error message: " + result.message)

        self.assertEqual(result.code, 200, "error code: " + str(result.code))
        self.assertIsNotNone(result.data, "error message: " + result.message)

    def test_find_by_opid(self):
        result = plan.find_by_opid(opid = "101000100412")
        print(result)
        self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)
        self.assertIsNotNone(result.data, "error message: " + result.message)

    def test_get_by_id(self):
        result = plan.get_by_id(392)
        print(result)
        self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)
        self.assertIsNotNone(result.data, "error message: " + result.message)

    def test_write(self):
        file_path = "/Users/wsl/temp/csst/import/plan_test1.json"
        result = plan.write_file(local_file = file_path)
        print(result)
        self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)

    def test_new(self):
        data = {'id':10399, 'opid':'1', 'instrument':'MSC', 'obs_type': 'SCIE', 'obs_id': '1'}
        result = plan.new(data = data)
        print(result)
        self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)
    
    def test_count_plan_level0(self):
        result = plan.count_plan_level0(
            instrument = 'MSC',
            obs_group = '1',
            obs_type = 'SCIE',
            dataset = 'default'
        )
        print(result)
        self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)   
