import unittest
import time
from csst_dfs_client import user

class UserTestCase(unittest.TestCase):

    def setUp(self):
        pass

    def test_find(self):
        result = user.find(key="s")
        print(result)
        self.assertEqual(result.code, 200, "error code: " + result.message)
        self.assertIsNotNone(result.data, "error message: " + result.message)

    def test_login(self):
        result = user.login(username="test", password="123456")
        print(result)
        self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)
        self.assertIsNotNone(result.data, "error message: " + result.message)

    def test_add_user(self):
        result = user.add(username="test", password="123456", nickname="test", email="test@test.com", role="user")
        print(result)
        self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)

    def test_update_user(self):
        result = user.update(username="test", nickname="test", email="test@test.com", role="user")
        print(result)
        self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)

    def test_delete_user(self):
        result = user.delete(username="test")
        print(result)
        self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)

    def test_passwd(self):
        result = user.passwd(old_password="123456", new_password="123456")
        print(result)
        self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)

