import unittest
from csst_dfs_client.common.utils import is_valid_datetime_format

class TestIsValidDatetimeFormat(unittest.TestCase):
    def test_valid_basic_format(self):
        """测试有效的基础格式日期时间"""
        self.assertTrue(is_valid_datetime_format("2023-05-15 14:30:00"))
    
    def test_valid_iso_format_without_timezone(self):
        """测试有效的ISO格式（不带时区）日期时间"""
        self.assertTrue(is_valid_datetime_format("2023-05-15T14:30:00"))
    
    def test_valid_iso_format_with_timezone(self):
        """测试有效的ISO格式（带时区）日期时间"""
        self.assertTrue(is_valid_datetime_format("2023-05-15T14:30:00+08:00"))
    
    def test_valid_iso_format_with_timezone2(self):
        """测试有效的ISO格式（带时区）日期时间"""
        self.assertTrue(is_valid_datetime_format("2023-05-15T14:30:00.123"))
        
    def test_invalid_date_format(self):
        """测试无效的日期格式"""
        with self.assertRaises(ValueError):
            is_valid_datetime_format("2023/05/15 14:30:00")
    
    def test_invalid_time_format(self):
        """测试无效的时间格式"""
        with self.assertRaises(ValueError):
            is_valid_datetime_format("2023-05-15 14-30-00")
    
    def test_empty_string(self):
        """测试空字符串"""
        with self.assertRaises(ValueError):
            is_valid_datetime_format("")


if __name__ == '__main__':
    unittest.main()