import unittest

from csst_dfs_client import catalog

class CatalogTestCase(unittest.TestCase):

    def setUp(self):
        pass

    def test_search(self):
        result = catalog.search(
            ra=90,
            dec=24.5,
            radius=0.21,
            columns = ['ref_epoch','ra','ra_error','dec','dec_error','parallax','parallax_error','pmra','pmra_error','pmdec','pmdec_error','phot_g_mean_mag','source_id'],
            catalog_name='gaia3',
            min_mag=-1,
            max_mag=-1,
            obstime = -1,
            limit = 10
        )
        print(result)
        self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)
        self.assertIsNotNone(result.data, "error message: " + result.message)

    def test_get_catalog_names(self):
        result = catalog.all_catalog_names()
        print(result)
        self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)
        self.assertIsNotNone(result.data, "error message: " + result.message)

    def test_describe_catalog(self):
        result = catalog.describe_catalog('gaia3_source')
        print(result)
        self.assertEqual(result.code, 200, "error code: " + str(result.code) + ", message: " + result.message)
        self.assertIsNotNone(result.data, "error message: " + result.message)
