"""
Identifier:     csst_common/utils/__init__.py
Name:           __init__.py
Description:    CSST utils
Author:         Bo Zhang
Created:        2022-09-19
Modified-History:
    2022-09-19, Bo Zhang, created
    2023-12-15, Bo Zhang, add module header
"""

import secrets
import string


def randfile(digits=20, ext=".fits"):
    """

    Parameters
    ----------
    digits
    ext

    Returns
    -------

    Examples
    --------
    >>> fname = randfile(20)
    >>> print(fname)

    """
    # 生成包含大小写字母和数字的字符集
    characters = string.ascii_letters + string.digits
    # 使用secrets模块生成指定长度的随机字符串
    random_string = ''.join(secrets.choice(characters) for _ in range(digits)) + ext
    return random_string
