"""
Identifier:     csst_common/utils/_retry.py
Name:           _retry.py
Description:    CSST utils
Author:         Bo Zhang
Created:        2023-12-20
Modified-History:
    2023-12-20, Bo Zhang, add retry
"""


def retry(func, *args, **kwargs):
    if "n_try" in kwargs.keys():
        n_try = kwargs.pop("n_try")
    else:
        n_try = 5
    # is DFS?
    try:
        assert func.__self__.__class__.__module__.startswith("csst_dfs_api"), func
        is_dfs = True
    except BaseException:
        is_dfs = False
    # start trials
    for attempt in range(n_try):
        print(f"Trial #{attempt}: call {func}")
        try:
            res = func(*args, **kwargs)
            if is_dfs:
                assert res["code"] == 0, res
            return res
        except BaseException as e:
            print(f"Error occurs: {e.__repr__()}")
            print(f" - func: {func}")
            print(f" - args: {args}")
            print(f" - kwargs: {kwargs}")
    raise RuntimeError(f"All {n_try} attempts failed.")
