"""
Identifier:     tests/test_file.py
Name:           test_file.py
Description:    test File class
Author:         Bo Zhang
Created:        2023-12-13
Modified-History:
    2023-12-13, Bo Zhang, add TestFile
    2023-12-15, Bo Zhang, add module header
"""
import unittest

from csst_common.cicd import File


class TestFile(unittest.TestCase):
    def test_file(self):
        file_path = (
            "/dfs_root/L0/MSC/SCI/61605/10160000072/MS/"
            "CSST_MSC_MS_SCIE_20270719043315_20270719043545_10160000072_07_L0_V01.fits"
        )
        file = File(file_path, new_dir="/pipeline/output")
        self.assertTrue(file.mo.groupdict() is not None)
        self.assertEqual(
            file.derive0(),
            (
                "/pipeline/output/"
                "CSST_MSC_MS_SCIE_20270719043315_20270719043545_10160000072_07_L0_V01.fits"
            ),
        )

        self.assertEqual(
            file.derive1(),
            (
                "/pipeline/output/"
                "CSST_MSC_MS_SCIE_20270719043315_20270719043545_10160000072_07_L1_V01.fits"
            ),
        )
        self.assertEqual(
            file.derive1(version=2),
            (
                "/pipeline/output/"
                "CSST_MSC_MS_SCIE_20270719043315_20270719043545_10160000072_07_L1_V02.fits"
            ),
        )

        self.assertEqual(
            file.derive2(),
            (
                "/pipeline/output/"
                "CSST_MSC_MS_SCIE_20270719043315_20270719043545_10160000072_07_L2_V01.fits"
            ),
        )

        self.assertEqual(
            file.derive2(ext=".cat"),
            (
                "/pipeline/output/"
                "CSST_MSC_MS_SCIE_20270719043315_20270719043545_10160000072_07_L2_V01.cat"
            ),
        )
