"""
Identifier:     tests/test_fits_header_ops.py
Name:           test_fits_header_ops.py
Description:    test append_header
Author:         Bo Zhang
Created:        2023-12-15
Modified-History:
    2023-12-15, Bo Zhang, add TestFitsHeaderOps.test_append_header
    2023-12-15, Bo Zhang, add TestFitsHeaderOps.test_reformat_header
"""

import os
import unittest

from csst_common import fits

test_fits_file = os.path.join(
    os.environ["UNIT_TEST_DATA_ROOT"],
    "csst_common/test_fits/hl.fits",
)


class TestFitsHeaderOps(unittest.TestCase):

    def test_fits_open(self):
        hl = fits.open(test_fits_file)
        self.assertIsInstance(hl, fits.HDUList)

    def test_fits_header(self):
        header = fits.getheader(test_fits_file, ext=0)
        self.assertIsInstance(header, fits.Header)

    def test_fits_getval(self):
        val = fits.getval(test_fits_file, ext=0, keyword="SIMPLE")
        self.assertEqual(val, True)

    def test_fits_getdata(self):
        data = fits.getdata(test_fits_file, ext=0)
        self.assertEqual(data, None)
