"""
Identifier:     csst_common/dfs.py
Name:           dfs.py
Description:    DFS wrapper
Author:         Bo Zhang
Created:        2023-07-08
Modified-History:
    2023-07-08, Bo Zhang, implemented DFS
    2023-07-11, Bo Zhang, updated DFS
    2023-12-08, Bo Zhang, tweaks
    2023-12-20, Bo Zhang, do nothing in DFS.__init__()
    2023-12-28, Bo Zhang, add DFS.rec_to_table and DFS.rec_to_dlist
    2025-01-02, Bo Zhang, use csst_dfs_client
"""

from astropy.table import Table
from csst_dfs_client import (
    level0,
    level1,
    catalog,
    plan,
)

# from csst_dfs_api.common.catalog import CatalogApi
# from csst_dfs_api.facility import (
#     Level0DataApi,
#     Level0PrcApi,
#     Level1DataApi,
#     Level1PrcApi,
#     Level2DataApi,
#     Level2TypeApi,
#     OtherDataApi,
# )


class DFS:
    def __init__(self):
        self.level0 = level0
        self.level1 = level1
        self.catalog = catalog
        self.plan = plan
