"""
Identifier:     tests/test_logger.py
Name:           test_logger.py
Description:    test logger
Author:         Bo Zhang
Created:        2023-12-15
Modified-History:
    2023-12-15, Bo Zhang, add TestLogger
"""
import os
import unittest

from csst_common.logger import get_logger


class TestFile(unittest.TestCase):
    def test_file(self):
        logger = get_logger(filename="test_logger.log")
        print(os.getcwd())
        print("Type of logger:", type(logger))
        print("Name of logger:", logger.name)
        logger.debug("Well ..")
        logger.info("Hello ...")
        logger.warning("There ...")
        logger.error("Good morning ...")
        with open("test_logger.log", "r") as f:
            lines = f.readlines()
        self.assertTrue(lines[0].strip().endswith("Hello ..."))
        self.assertTrue(lines[1].strip().endswith("There ..."))
        self.assertTrue(lines[2].strip().endswith("Good morning ..."))
