"""
Identifier:     csst_common/utils/_retry.py
Name:           _retry.py
Description:    CSST utils
Author:         Bo Zhang
Created:        2023-12-20
Modified-History:
    2023-12-20, Bo Zhang, add retry
"""

import traceback


def retry(func, *args, **kwargs):
    if "n_try" in kwargs.keys():
        n_try = kwargs.pop("n_try")
    else:
        n_try = 5
    # is DFS?
    # TODO: support DFS2
    is_dfs = func.__class__.__module__.startswith("csst_dfs_client")
    # start trials
    for attempt in range(n_try):
        print(f"Trial #{attempt}: call {func}")
        try:
            res = func(*args, **kwargs)
            if is_dfs:
                # TODO: support DFS2
                assert res.success, res
            return res
        except Exception as e:
            # print error messages
            print(f"Error occurs in trial {attempt + 1}/{n_try}:")
            print(f" - Error type: {type(e).__name__}")
            print(f" - Error message: {str(e)}")
            print(f" - Function: {func}")
            print(f" - Args: {args}")
            print(f" - Kwargs: {kwargs}")
            # 打印完整的堆栈跟踪
            print(" - Stack trace:")
            traceback.print_exc()
            if attempt == n_try - 1:
                print(f"All {n_try} attempts failed. Reraising exception...")
                raise

    raise RuntimeError(f"All {n_try} attempts failed.")
