"""
Identifier:     csst_common/fits.py
Name:           fits.py
Description:    IO module
Author:         Bo Zhang
Created:        2025-10-23
Modified-History:
    2025-10-23, Bo Zhang, created, support FITS operations for s3
"""

from astropy.io.fits import *
from astropy.io import fits
from csst_fs.s3_config import load_s3_options

s3_options = load_s3_options()

s3_prefix = ("s3://", "s3a://")


def open(filename, **kwargs) -> fits.HDUList:
    if filename.startswith(s3_prefix):
        # read FITS file from s3
        return fits.open(filename, use_fsspec=True, fsspec_kwargs=s3_options, **kwargs)
    else:
        # read FITS file from local
        return fits.open(filename, **kwargs)


def getheader(filename, **kwargs) -> fits.HDUList:
    if filename.startswith(s3_prefix):
        # read FITS file from s3
        return fits.getheader(
            filename, use_fsspec=True, fsspec_kwargs=s3_options, **kwargs
        )
    else:
        # read FITS file from local
        return fits.getheader(filename, **kwargs)


def getval(filename, **kwargs) -> fits.HDUList:
    if filename.startswith(s3_prefix):
        # read FITS file from s3
        return fits.getval(
            filename, use_fsspec=True, fsspec_kwargs=s3_options, **kwargs
        )
    else:
        # read FITS file from local
        return fits.getval(filename, **kwargs)


def getdata(filename, **kwargs) -> fits.HDUList:
    if filename.startswith(s3_prefix):
        # read FITS file from s3
        return fits.getdata(
            filename, use_fsspec=True, fsspec_kwargs=s3_options, **kwargs
        )
    else:
        # read FITS file from local
        return fits.getdata(filename, **kwargs)
