"""
Identifier:     csst_common/time.py
Name:           time.py
Description:    time module
Author:         Bo Zhang
Created:        2023-03-09
Modified-History:
    2023-03-09, Bo Zhang, created
    2023-03-09, Bo Zhang, add two time formats
    2023-12-20, Bo Zhang, use astropy.time
"""
from astropy import time


def now():
    """Return ISOT format datetime using `astropy`."""
    return time.Time.now().isot


# def now():
#     """Return ISOT8601 format datetime, for time stamps in data products."""
#     return datetime.datetime.now().strftime("%Y-%m-%dT%H:%M:%S.%f")


# def now_dfs():
#     """Return ISOT8601 format datetime, for DFS usage only."""
#     return datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
