"""
Identifier:     csst_common/utils/_retry.py
Name:           _retry.py
Description:    CSST utils
Author:         Bo Zhang
Created:        2023-12-20
Modified-History:
    2023-12-20, Bo Zhang, add retry
    2026-01-13, Bo Zhang, simplify retry
"""

import traceback
from typing import Callable


def retry(n_try: int, func: Callable, *args, **kwargs):
    # start trials
    for i_try in range(n_try):
        print(f"Trial #{i_try}: call {func}")
        try:
            return func(*args, **kwargs)
        except Exception as e:
            # print error messages
            print(f"Error occurs in trial {i_try + 1}/{n_try}:")
            print(f" - Error type: {type(e).__name__}")
            print(f" - Error message: {str(e)}")
            print(f" - Function: {func}")
            print(f" - Args: {args}")
            print(f" - Kwargs: {kwargs}")
            # 打印完整的堆栈跟踪
            print(" - Stack trace:")
            traceback.print_exc()
            if i_try == n_try - 1:
                print(f"All {n_try} attempts failed. Reraising exception...")
                raise
    raise RuntimeError(f"All {n_try} attempts failed.")
