"""
Identifier:     tests/test_decorator.py
Name:           test_decorator.py
Description:    test decorator
Author:         Bo Zhang
Created:        2023-12-15
Modified-History:
    2023-12-10, Bo Zhang, add TestDecorator
    2023-12-15, Bo Zhang, add module header
"""
import unittest

from csst_common.decorator import parameterized_module_decorator
from csst_common.status import CsstStatus, CsstResult


class TestDecorator(unittest.TestCase):
    def test_parameterized_module_decorator(self):
        @parameterized_module_decorator()
        def call_add(a, b):
            if isinstance(a, float) and isinstance(b, float):
                return CsstResult(CsstStatus.PERFECT, files=None, result=a + b)
            else:
                return CsstResult(CsstStatus.ERROR, files=None, result=a + b)

        mres_int = call_add(1, 2)
        self.assertEqual(mres_int.module, "call_add")
        self.assertGreater(mres_int.cost, 0)
        self.assertTrue(mres_int.status, CsstStatus(2))

        mres_float = call_add(1, 2)
        self.assertEqual(mres_float.module, "call_add")
        self.assertGreater(mres_float.cost, 0)
        self.assertTrue(mres_float.status, CsstStatus(0))
