"""
Identifier:     csst_common/fits.py
Name:           fits.py
Description:    IO module
Author:         Bo Zhang
Created:        2025-10-23
Modified-History:
    2025-10-23, Bo Zhang, created, support FITS operations for s3
"""

from astropy.io.fits import *
from astropy.io import fits
from csst_fs.s3_config import load_s3_options

s3_options = load_s3_options()


def open(name, **kwargs) -> fits.HDUList:
    if name.startswith("s3://"):
        # read FITS file from s3
        return fits.open(name, use_fsspec=True, fsspec_kwargs=s3_options, **kwargs)
    else:
        # read FITS file from local
        return fits.open(name, **kwargs)


def getheader(name, **kwargs) -> fits.HDUList:
    if name.startswith("s3://"):
        # read FITS file from s3
        return fits.getheader(name, use_fsspec=True, fsspec_kwargs=s3_options, **kwargs)
    else:
        # read FITS file from local
        return fits.getheader(name, **kwargs)


def getval(name, **kwargs) -> fits.HDUList:
    if name.startswith("s3://"):
        # read FITS file from s3
        return fits.getval(name, use_fsspec=True, fsspec_kwargs=s3_options, **kwargs)
    else:
        # read FITS file from local
        return fits.getval(name, **kwargs)


def getdata(name, **kwargs) -> fits.HDUList:
    if name.startswith("s3://"):
        # read FITS file from s3
        return fits.getdata(name, use_fsspec=True, fsspec_kwargs=s3_options, **kwargs)
    else:
        # read FITS file from local
        return fits.getdata(name, **kwargs)
