"""
Identifier:     csst_dadel/csst_dadel/utils.py
Name:           utils.py
Description:    Table utils.
Author:         Bo Zhang
Created:        2024-02-18
Modified-History:
    2024-02-18, Bo Zhang, implement utils for conversion between Table and BinTableHDU
"""
from astropy import table
from astropy.io import fits


def table_to_hdu(tbl: table.Table, name: str = "") -> fits.BinTableHDU:
    """Convert a table to a BinTableHDU."""
    # encode meta
    encoded_tbl = fits.connect._encode_mixins(tbl)
    # convert to HDU
    hdu = fits.table_to_hdu(encoded_tbl)
    # add HDU name
    hdu.name = name
    return hdu


def hdu_to_table(hdu: fits.BinTableHDU) -> table.Table:
    """Convert a BinTableHDU to a table."""
    return table.Table.read(hdu)
