import fsspec
from astropy.io import fits
from ..fsspec_fileobj import open_fileobj
from ..s3_config import load_s3_options

def tofile(fits_header, out_path, s3_options=load_s3_options(), *args, **kwargs):
    fileobj = open_fileobj(out_path, s3_options)
    fits_header.tofile(fileobj, *args, **kwargs)
    if hasattr(fileobj, 'close'):
        fileobj.close()

def fromfile(filename, s3_options=load_s3_options(), *args, **kwargs):
    fileobj = open_fileobj(filename, s3_options, mode='rb')
    return fits.Header.fromfile(fileobj, *args, **kwargs)