import os
import json

default_s3_options = {
    'key': 'minioadmin', 
    'secret': 'minioadmin', 
    'endpoint_url': 'http://localhost:9000/'
}

def load_from_env():
    s3_options = {
        'key': os.getenv('S3_KEY'),
        'secret': os.getenv('S3_SECRET'),
        'endpoint_url': os.getenv('S3_ENDPOINT_URL')
    }
    return s3_options

def load_s3_options():
    if 'S3_KEY' in os.environ:
        return load_from_env()
    return default_s3_options