import fsspec
from astropy import table
from ..fsspec_fileobj import open_fileobj
from ..s3_config import load_s3_options

def read(filename, s3_options=load_s3_options(), *args, **kwargs):
    fileobj = open_fileobj(filename, s3_options, mode='rb')
    return table.Table.read(fileobj, *args, **kwargs)

def write(table_to_write: table.Table, filename, s3_options=load_s3_options(), *args, **kwargs):
    fileobj = open_fileobj(filename, s3_options, mode='wb')
    return table_to_write.write(fileobj, *args, **kwargs)