import fsspec
from astropy.io import fits
from ..fsspec_fileobj import open_fileobj
from ..s3_config import load_s3_options

def writeto(fits_HDUList, out_path, *args, s3_options=load_s3_options(), **kwargs):
    fileobj = open_fileobj(out_path, s3_options, mode='wb')
    fits_HDUList.writeto(fileobj, *args, **kwargs)
    if hasattr(fileobj, 'close'):
        fileobj.close()

def fromfile(filename, *args, s3_options=load_s3_options(), **kwargs):
    fileobj = open_fileobj(filename, s3_options, mode='rb')
    return fits.HDUList.fromfile(fileobj, *args, **kwargs)
    