from .s3_fs import is_s3_path
from .s3_fs import isfile as s3_isfile
from .local_fs import isfile as local_isfile

def isfile(path: str, *args, **kwargs) -> bool:
    if is_s3_path(path):
        return s3_isfile(path, *args, **kwargs)
    else:
        return local_isfile(path, *args, **kwargs)
