import os

default_s3_options = {
    'key': 'hNddG0c56pAs6gfq',
    'secret': 'NTyeYsGopizjwSm4PgtfB8kNq8HmPu',
    'endpoint_url': 'http://oss-cn-hangzhou-zjy-d01-a.ops.cloud.zhejianglab.com',
}

default_s3_settings = {
    'bucket': 'data-and-computing'
}

default_backend_settings = {
    'backend_url': 'https://astro-workbench.eva.lab.zverse.space:32443/api/csst',
}

def load_from_env():
    s3_options = {
        'key': os.getenv('S3_KEY'),
        'secret': os.getenv('S3_SECRET'),
        'endpoint_url': os.getenv('S3_ENDPOINT_URL'),
    }
    return s3_options

def load_settings_from_env():
    s3_settings = {
        'bucket': os.getenv('S3_BUCKET'),
    }
    return s3_settings

def load_backend_settings_from_env():
    backend_settings = {
        'backend_url': os.getenv('CSST_BACKEND_API_URL'),
    }
    return backend_settings

def load_s3_options():
    if 'S3_KEY' in os.environ:
        return load_from_env()
    return default_s3_options

def load_s3_settings():
    if 'S3_BUCKET' in os.environ:
        return load_settings_from_env()
    return default_s3_settings

def load_backend_settings():
    if 'CSST_BACKEND_API_URL' in os.environ:
        return load_backend_settings_from_env()
    return default_backend_settings
