from datetime import datetime
    
"""
Adapted from csst-dfs-api.
"""
def is_valid_datetime_format(date_str: str) -> bool:
    try:
        # 尝试不带时区的基础格式
        datetime.strptime(date_str, '%Y-%m-%d %H:%M:%S')
        return True
    except ValueError:
        try:
            # 尝试ISO格式（带或不带时区）
            datetime.fromisoformat(date_str.replace(' ', 'T'))
            return True
        except ValueError:
            raise ValueError("Incorrect data format")
    
def get_current_time() -> str:
    return datetime.now().strftime('%Y-%m-%d %H:%M:%S')
