from astropy.io import fits
from ..fsspec_fileobj import open_fileobj
from ..s3_config import load_s3_options

def open(filename, *args, s3_options=load_s3_options(), **kwargs):
    return fits.open(filename, *args, fsspec_kwargs=s3_options, **kwargs)

def getdata(filename, *args, s3_options=load_s3_options(), **kwargs):
    fileobj = open_fileobj(filename, s3_options, mode='rb')
    return fits.getdata(fileobj, *args, **kwargs)

def getheader(filename, *args, s3_options=load_s3_options(), **kwargs):
    fileobj = open_fileobj(filename, s3_options, mode='rb')
    return fits.getheader(fileobj, *args, **kwargs)