# Adapted from csst-dfs.csst-dfs-client.csst-dfs-client.common.__init__ (20251212)
class PipelineResult(dict):
    '''
    类Result用于封装返回结果，包含success、message、data三个属性:
        success (bool): 是否成功
        message (str): 消息
        data (any): 数据
    '''
    __setattr__ = dict.__setitem__
    __getattr__ = dict.__getitem__
    def __init__(self):
        super(PipelineResult, self).__init__()
        self["code"] = 200
        self["message"] = ""
        self["data"] = None
    
    @property
    def success(self) -> bool:
        return self["code"] == 200

    @property
    def data(self) -> any:
        return self["data"]

    @property
    def message(self) -> str:
        return str(self["message"])
