from astropy.io import fits
from ..fsspec_fileobj import open_fileobj
from ..s3_config import load_s3_options

def open(filename, s3_options=load_s3_options(), *args, **kwargs):
    return fits.open(filename, fsspec_kwargs=s3_options, *args, **kwargs)

def getdata(filename, s3_options=load_s3_options(), *args, **kwargs):
    fileobj = open_fileobj(filename, s3_options, mode='rb')
    return fits.getdata(fileobj, *args, **kwargs)

def getheader(filename, s3_options=load_s3_options(), *args, **kwargs):
    fileobj = open_fileobj(filename, s3_options, mode='rb')
    return fits.getheader(fileobj, *args, **kwargs)