import fsspec

def open_fileobj(path: str, s3_options, mode='w'):
    if(path.startswith("s3")):
        s3_fs = fsspec.filesystem('s3', **s3_options)
        fileobj = s3_fs.open(path, mode=mode).__enter__()
    else:
        fileobj = open(path, mode=mode).__enter__()
    return fileobj