from .s3_fs import is_s3_path
from .s3_fs import isfile as s3_isfile
from .s3_fs import delete as s3_delete
from .local_fs import delete as local_delete
from .local_fs import isfile as local_isfile

def isfile(path: str, *args, **kwargs) -> bool:
    if is_s3_path(path):
        return s3_isfile(path, *args, **kwargs)
    else:
        return local_isfile(path, *args, **kwargs)

def delete(path, **kwargs):
    if is_s3_path(path):
        s3_delete(path, **kwargs)
    else:
        local_delete(path, **kwargs)
