import fsspec
from .s3_config import load_s3_options
from .fsspec_fileobj import open_fileobj

def put(lpath, rpath, recursive=False, callback=fsspec.callbacks.DEFAULT_CALLBACK, maxdepth=None, s3_options=load_s3_options(), **kwargs,): 
    s3_fs = fsspec.filesystem('s3', **s3_options)
    s3_fs.put(lpath, rpath, recursive, callback, maxdepth, **kwargs)

def get(rpath, lpath, recursive=False, callback=fsspec.callbacks.DEFAULT_CALLBACK, maxdepth=None, s3_options=load_s3_options(), **kwargs,):
    s3_fs = fsspec.filesystem('s3', **s3_options)
    s3_fs.get(rpath, lpath, recursive, callback, maxdepth, **kwargs)

def info(path, bucket=None, key=None, refresh=False, version_id=None, s3_options=load_s3_options()) -> dict:
    s3_fs = fsspec.filesystem('s3', **s3_options)
    return s3_fs.info(path, bucket, key, refresh, version_id)

def open(file: str, mode: str='r', s3_options=load_s3_options()):
    return open_fileobj(path=file, s3_options=s3_options, mode=mode)