import fsspec
from .s3_config import load_s3_options, load_s3_settings
from .fsspec_fileobj import open_fileobj

def put(lpath, rpath, recursive=False, callback=fsspec.callbacks.DEFAULT_CALLBACK, maxdepth=None, s3_options=load_s3_options(), **kwargs,): 
    s3_fs = fsspec.filesystem('s3', **s3_options)
    s3_fs.put(lpath, rpath, recursive, callback, maxdepth, **kwargs)

def get(rpath, lpath, recursive=False, callback=fsspec.callbacks.DEFAULT_CALLBACK, maxdepth=None, s3_options=load_s3_options(), **kwargs,):
    s3_fs = fsspec.filesystem('s3', **s3_options)
    s3_fs.get(rpath, lpath, recursive, callback, maxdepth, **kwargs)

def get_path(remote_path, local_path, recursive=False, callback=fsspec.callbacks.DEFAULT_CALLBACK, maxdepth=None, s3_options=load_s3_options(), **kwargs,):
    s3_fs = fsspec.filesystem('s3', **s3_options)
    bucketAndKey = load_s3_settings()['bucket'] + "/" + remote_path
    s3_fs.get(bucketAndKey, local_path, recursive, callback, maxdepth, **kwargs)

def info(path, bucket=None, key=None, refresh=False, version_id=None, s3_options=load_s3_options()) -> dict:
    s3_fs = fsspec.filesystem('s3', **s3_options)
    return s3_fs.info(path, bucket, key, refresh, version_id)

def info_path(remote_path, refresh=False, version_id=None, s3_options=load_s3_options()) -> dict:
    s3_fs = fsspec.filesystem('s3', **s3_options)
    bucketAndKey = load_s3_settings()['bucket'] + "/" + remote_path
    return s3_fs.info(bucketAndKey, None, None, refresh, version_id)

def open(file: str, mode: str='r', s3_options=load_s3_options()):
    return open_fileobj(path=file, s3_options=s3_options, mode=mode)

def open_path(path: str, mode: str='r', s3_options=load_s3_options()):
    bucketAndKey = "s3://" + load_s3_settings()['bucket'] + "/" + path
    return open_fileobj(path=bucketAndKey, s3_options=s3_options, mode=mode)

def isfile(path: str, s3_options: dict=load_s3_options()) -> bool:
    s3_fs = fsspec.filesystem('s3', **s3_options)
    return s3_fs.isfile(path)

def delete(path: str, *, recursive=False, maxdepth=None, s3_options: dict=load_s3_options(), **kwargs):
    s3_fs = fsspec.filesystem('s3', **s3_options)
    s3_fs.delete(path, recursive, maxdepth)
    
def is_s3_path(path: str):
    if(path.startswith("s3")):
        return True
    return False
