## csst\_proto

CSST 流水线原型，用于展示示例代码

## dependencies

- numpy==1.26.1
- scipy==1.11.3
- astropy==5.3.4
- joblib==1.3.0
- toml==0.10.2

## installation

`csst_proto` 可用如下方式安装

```shell
git clone https://csst-tb.bao.ac.cn/code/csst-l1/csst_proto.git
cd csst_proto
pip install .
```

或者单行命令：

```shell
pip install --force-reinstall git+https://csst-tb.bao.ac.cn/code/csst-l1/csst_proto.git
```

## tutorial

一个简单使用教程

```python
from csst_proto import flip_image
from astropy.io import fits

# read an L0 image
img = fits.getdata("CSST_MS_SCI_06_L0_img.fits")
# flip the image
img_flipped = flip_image(image=img)
```

## algorithm description

The `csst_proto` uses an awesome algorithm based on `numpy.ndarray` indices to flip images.
