// Simple C program to display "Hello World"

// Header file for input output functions
#include <Python.h>

static PyObject* _helloworld(PyObject* self, PyObject* args)
{
    printf("Hello World\n");
    return Py_None;
}

static PyMethodDef Methods[] = {
    { "helloworld", _helloworld, METH_NOARGS, "Prints Hello World" },
    { NULL, NULL, 0, NULL }
};

// Our Module Definition struct
static struct PyModuleDef Module = {
    PyModuleDef_HEAD_INIT,
    "helloworld",
    "prints Hello World",
    -1,
    Methods
};

// Initializes our module using our above struct
PyMODINIT_FUNC PyInit_helloworld(void)
{
    return PyModule_Create(&Module);
}
