"""
Identifier:     csst_proto/__init__.py
Name:           __init__.py
Description:    这个文件导入了若干子模块中的函数，Jenkins将检查__all__列表中对象的的代码风格(PEP8, Numpydoc)
Author:         Bo Zhang
Created:        2023-10-26
Modified-History:
    2023-10-26, Bo Zhang, add module header
    2023-10-30, Bo Zhang, finalize the __all__ list
"""
from .demo import demo_function, DemoClass
from .flip import flip_image, read_default_image
from .flip_in_parallel import flip_multiple_images_jl, flip_multiple_images_mp
from .config import read_config

# 版本号，可以通过csst_proto.__version__获取
__version__ = "0.0.1"

# 定义__all__变量，其中所有的对象会被检查类型标注和docstring
__all__ = [
    "demo_function",
    "DemoClass",
    "flip_image",
    "read_default_image",
    "flip_multiple_images_jl",
    "flip_multiple_images_mp",
    "read_config",
]
