"""
Identifier:     csst_proto/demo.py
Name:           demo.py
Description:    这个文件包括了一个读取toml格式配置文件的函数
Author:         Bo Zhang
Created:        2023-10-26
Modified-History:
    2023-10-26, Bo Zhang, add module header
    2023-10-28, Bo Zhang, add read_config
"""

import toml
import os
import pathlib
from typing import Optional

# 如何找到当前.py文件所在的文件夹绝对路径?
# 方法1: 使用 pathlib
# HERE: pathlib.Path = pathlib.Path(__file__).parent.resolve()
# 方法2: 使用 os
HERE: str = os.path.dirname(__file__)


# 这个函数演示了如何利用随包数据
# 当config_path被指定时，会读取指定的config_path
# 当config_path=None时，读取随包数据中的config/default_config.toml
def read_config(config_path: Optional[str] = None) -> dict:
    """
    Get config info from a toml file.

    Read a `toml` format config file.
    If `config_path` is specified, read that config.
    Otherwise, read the default config in `config/default_config.toml`.

    Parameters
    ----------
    config_path : Optional[str]
        The config file path.

    Returns
    -------
    dict
        The configuration dictionary.
    """
    # if config_path is specified, use it, otherwise use the default
    if config_path is None:
        config_path: str = os.path.join(HERE, "data", "default_config.toml")
    # read the config file
    config: dict = toml.load(config_path)
    return config
