"""
Identifier:     csst_proto/demo.py
Name:           demo.py
Description:    这个文件包括了一个演示函数和演示类
Author:         Bo Zhang
Created:        2023-10-26
Modified-History:
    2023-10-28, Bo Zhang, add module header
"""

from typing import Any


def demo_function(*args: Any) -> int:
    """
    A demo function.

    This function count the input positional arguments and returns the counts.

    Parameters
    ----------
    *args : Any
        The input positional arguments.

    Returns
    -------
    int
        The count of input positional arguments.

    Examples
    --------
    >>> demo_function(None)
    """
    return len(args)


class DemoClass:
    """
    A demo class.

    This class is a demo.
    This is a second-line comment for extended summary.

    Parameters
    ----------
    first_name : str
        The first name.
    last_name : str
        The last name.

    Attributes
    ----------
    first_name : str
        The first name.
    last_name : str
        The last name.

    Methods
    -------
    say_hello()
        Print hello message.

    Examples
    --------
    >>> a = DemoClass("Jane", "Doe")
    >>> a.say_hello()
    """

    def __init__(self, first_name: str, last_name: str) -> None:
        self.first_name = first_name
        self.last_name = last_name

    def say_hello(self) -> None:
        """111"""
        print("Hello, {} {}!".format(self.first_name, self.last_name))
