import setuptools

# 读取README.md作为长描述
with open("README.md", "r") as f:
    long_description = f.read()

# 读取依赖列表requirements.txt
# 忽略#开头或者版本号不明确指定的条目
with open("requirements.txt", "r") as f:
    requirements = [
        req.strip()
        for req in f.readlines()
        if not req.startswith("#") and req.__contains__("==")
    ]

# 配置、安装
setuptools.setup(
    name="csst_proto",  # 包名
    version="0.0.1",  # 版本号
    author="Bo Zhang",  # 作者
    author_email="bozhang@nao.cas.cn",  # 邮箱
    description="The CSST L1 pipeline - prototype",  # 短描述
    long_description=long_description,  # 长描述
    long_description_content_type="text/markdown",  # 长描述类型
    url="https://csst-tb.bao.ac.cn/code/csst-l1/csst_proto",  # 主页
    packages=setuptools.find_packages(where="."),  # 用setuptools工具自动发现带有__init__.py的包
    license="MIT",  # 证书类型
    classifiers=[  # 程序分类, 参考 https://pypi.org/classifiers/
        # How mature is this project?
        #   3 - Alpha
        #   4 - Beta
        #   5 - Production/Stable
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Science/Research",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Topic :: Scientific/Engineering :: Physics",
        "Topic :: Scientific/Engineering :: Astronomy",
    ],
    include_package_data=True,  # 设置包含随包数据
    package_data={  # 具体随包数据路径
        "csst_proto": ["data/*"],
    },
    # 请注意检查，防止临时文件或其他不必要的文件被提交到仓库，否则会一同安装
    python_requires=">=3.11",  # Python版本要求
    install_requires=requirements,
    ext_modules=[  # 如果有随包的C代码，需要在这里定义扩展
        setuptools.Extension(
            name="csst_proto.cext.helloworld",
            sources=["cextern/helloworld.c"],
        )
    ],
)
