"""
Identifier:     csst_proto/test_config.py
Name:           test_config.py
Description:    Test reading toml format config.
Author:         Bo Zhang
Created:        2023-10-26
Modified-History:
    2023-10-26, Bo Zhang, created
    2023-10-26, Bo Zhang, add module header
"""

import unittest
from csst_proto import read_config


class TestDemoFunction(unittest.TestCase):
    def test_read_config(self):
        """
        Aim
        ---
        Test demo function.

        Criteria
        --------
        Pass if the demo function returns `1`.

        Details
        -------
        The demo function returns the length of the input argument list.
        This case aims to test whether the demo function returns `1` if input is `None`.
        """
        # demo function test
        config = read_config()
        self.assertTrue(
            set(config.keys()) == {"A", "B"} and config["A"] == 1 and config["B"] == 2,
            "Single-argument case failed.",
        )
