"""
Identifier:     csst_proto/test_demo_function.py
Name:           test_demo_function.py
Description:    Test demo function.
Author:         Bo Zhang
Created:        2023-10-26
Modified-History:
    2023-10-26, Bo Zhang, created
    2023-10-26, Bo Zhang, add module header
"""

import unittest
from csst_proto import demo_function


class TestDemoFunction(unittest.TestCase):
    def test_demo_function_1(self):
        """
        Aim
        ---
        Test demo function.

        Criteria
        --------
        Pass if the demo function returns `1`.

        Details
        -------
        The demo function returns the length of the input argument list.
        This case aims to test whether the demo function returns `1` if input is `None`.
        """
        # demo function test
        self.assertTrue(
            demo_function(None) == 1,
            "Single-argument case failed.",
        )

    def test_demo_function_2(self):
        """
        Aim
        ---
        Test demo function.

        Criteria
        --------
        Pass if the demo function returns `2`.

        Details
        -------
        The demo function returns the length of the input argument list.
        This case aims to test whether the demo function returns `2` if input is `None, None`.
        """
        # demo function test
        self.assertEqual(
            demo_function(None, None),
            2,
            "Double-argument case failed.",
        )

    def test_demo_function_bad_case(self):
        """
        Aim
        ---
        Test demo function in bad case.

        Criteria
        --------
        Pass if the demo function result is not equal to `2`.

        Details
        -------
        The demo function returns the length of the input argument list.
        This case aims to test whether the demo function result is not equal to `2`
        if input is `None, None, None`.
        """
        # demo function test
        self.assertNotEqual(
            demo_function(None, None, None),
            2,
            "Triple-argument case failed.",
        )
